const express = require('express');
const path = require('path');

const app = express();
const PORT = process.env.PORT || 3000;

app.use(express.json());
app.use(express.urlencoded({ extended: true }));
app.use(express.static(path.join(__dirname, 'public')));

function validateCityName(city) {
    const errors = [];
    if (!city || String(city).trim() === '') {
        errors.push('City name is required.');
    }
    if (city && city.length > 100) {
        errors.push('City name is too long.');
    }
    return errors;
}

app.get('/api/weather', async (req, res) => {
    const { city, units } = req.query;
    const errors = validateCityName(city);

    if (errors.length) {
        return res.status(400).json({ success: false, errors });
    }

    const finalUnits = units === "imperial" ? "imperial" : "metric";

    const apiKey = "48be805101aa9679c8ae84dbcbe7419c"; 

    try {
        const q = encodeURIComponent(city);
        const url = `https://api.openweathermap.org/data/2.5/weather?q=${q}&units=${finalUnits}&appid=${apiKey}`;

        const response = await fetch(url);
        const data = await response.json();

        if (!response.ok) {
            return res.status(response.status).json({
                success: false,
                errors: [data.message || "Failed to fetch weather."]
            });
        }

        const weatherData = {
            name: data.name,
            country: data.sys.country,
            temp: data.main.temp,
            feels_like: data.main.feels_like,
            humidity: data.main.humidity,
            description: data.weather[0].description,
            icon: data.weather[0].icon,
            wind_speed: data.wind.speed
        };

        res.json({ success: true, data: weatherData });

    } catch (error) {
        console.error(error);
        res.status(500).json({
            success: false,
            errors: ["Internal server error."]
        });
    }
});

app.listen(PORT, () => {
    console.log(`Server running on port ${PORT}`);
    console.log(`Open in browser: http://localhost:${PORT}`);
});

